/*
 * Decompiled with CFR 0.152.
 */
package DE.siemens.ad.logo.model.panel;

import DE.siemens.ad.logo.app.comp.DataInputPanel;
import DE.siemens.ad.logo.app.comp.RolloverButton;
import DE.siemens.ad.logo.dialog.comp.display.DisplayElement;
import DE.siemens.ad.logo.dialog.comp.display.DisplayElementInsertHandler;
import DE.siemens.ad.logo.dialog.comp.display.ExtenalMoveModel;
import DE.siemens.ad.logo.dialog.comp.display.LogoDisplay;
import DE.siemens.ad.logo.dialog.comp.display.MessageParameterDisplayModelRTF;
import DE.siemens.ad.logo.dialog.comp.display.OneCharacterCellEditor;
import DE.siemens.ad.logo.util.Global;
import DE.siemens.ad.logo.util.Language;
import DE.siemens.ad.logo.util.LogoError;
import DE.siemens.ad.logo.util.ProgramException;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public class MessageEditorPanel
extends DataInputPanel {
    private static final long serialVersionUID = 1L;
    private JLabel fMessageLabel = null;
    private LogoDisplay fMessageDisplay = null;
    private JLabel fUnusedLabel = null;
    private LogoDisplay fUnusedDisplay = null;
    private StaticModel fMessageModel;
    private StaticModel fUnusedModel;
    MessageParameterDisplayModelRTF fMessageParameterDisplayModelRTF;
    private JLabel fTextLabel = null;
    private JTextArea fTextArea;
    private DisplayElement fInsertedElement = null;
    private Transferable fClipboardContent;
    private Point fEditedCell = null;

    public MessageEditorPanel(MessageParameterDisplayModelRTF model) {
        this.initialize(model);
    }

    public void setElementToCycleBin(DisplayElement disp) {
        this.fInsertedElement = disp;
    }

    public void setCellToBeRemoved(Point cell) {
        this.fEditedCell = cell;
    }

    public void setClipboardContent(Transferable contents) {
        this.fClipboardContent = contents;
    }

    public String getTitle() {
        return Language.getString("dialog.parameter.message.EditManually.title", "Static editor");
    }

    private void initialize(MessageParameterDisplayModelRTF model) {
        this.fMessageParameterDisplayModelRTF = model;
        this.setLayout(new BoxLayout(this, 3));
        this.fMessageModel = new StaticModel(model);
        this.fMessageDisplay = new LogoDisplay();
        this.fMessageDisplay.setModel(this.fMessageModel);
        this.initLogoDisplay(this.fMessageDisplay);
        this.fMessageDisplay.setDefaultCellEditor(new OneCharacterCellEditor());
        this.fUnusedModel = new StaticModel(model);
        this.fUnusedModel.clearAll();
        this.fUnusedDisplay = new LogoDisplay();
        this.fUnusedDisplay.setModel(this.fUnusedModel);
        this.initLogoDisplay(this.fUnusedDisplay);
        this.fMessageLabel = new JLabel();
        JPanel msgPanel = new JPanel();
        msgPanel.setLayout(new BoxLayout(msgPanel, 3));
        this.addComponentLeft(msgPanel, this.fMessageLabel);
        this.addComponentLeft(msgPanel, this.fMessageDisplay);
        msgPanel.add(Box.createRigidArea(new Dimension(5, 15)));
        this.addComponentCenter(this, msgPanel);
        this.addComponentCenter(this, this.getToolBarPanel());
        this.fUnusedLabel = new JLabel();
        JPanel unusedPanel = new JPanel();
        unusedPanel.setLayout(new BoxLayout(unusedPanel, 3));
        this.addComponentLeft(unusedPanel, this.fUnusedLabel);
        this.addComponentLeft(unusedPanel, this.fUnusedDisplay);
        unusedPanel.add(Box.createRigidArea(new Dimension(5, 15)));
        this.addComponentCenter(this, unusedPanel);
        this.fTextLabel = new JLabel();
        JPanel textPanel = new JPanel();
        textPanel.setLayout(new BoxLayout(textPanel, 3));
        this.addComponentLeft(textPanel, this.fTextLabel);
        this.addComponentLeft(textPanel, this.getTextArea());
        this.addComponentCenter(this, textPanel);
        this.fMessageModel.setTextListener(this.fTextArea);
        this.fUnusedModel.setTextListener(this.fTextArea);
    }

    private void addComponentLeft(JPanel parent, JComponent child) {
        child.setAlignmentX(0.0f);
        parent.add(child);
    }

    private void addComponentCenter(JPanel parent, JComponent child) {
        child.setAlignmentX(0.5f);
        parent.add(child);
    }

    private void initLogoDisplay(LogoDisplay display) {
        display.setCellRendererMode(LogoDisplay.MODE_DETAIL);
        display.setDragEnabled(true);
        display.setDropEnabled(true);
    }

    private JPanel getToolBarPanel() {
        JPanel toolbarPanel = new JPanel();
        toolbarPanel.setLayout(new BoxLayout(toolbarPanel, 0));
        RolloverButton copyDown = new RolloverButton(Global.getIcon("Next.gif"));
        toolbarPanel.add(copyDown);
        copyDown.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MessageEditorPanel.this.copyElements(MessageEditorPanel.this.fUnusedDisplay, MessageEditorPanel.this.fMessageDisplay);
            }
        });
        copyDown.setToolTipText(Language.getString("dialog.parameter.message.EditManually.toRecycleBinTip", "Move down"));
        RolloverButton copyUp = new RolloverButton(Global.getIcon("Previous.gif"));
        toolbarPanel.add(copyUp);
        copyUp.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MessageEditorPanel.this.copyElements(MessageEditorPanel.this.fMessageDisplay, MessageEditorPanel.this.fUnusedDisplay);
            }
        });
        copyUp.setToolTipText(Language.getString("dialog.parameter.message.EditManually.toTextAreaTip", "Move up"));
        return toolbarPanel;
    }

    private JScrollPane getTextArea() {
        this.fTextArea = new JTextArea("", 5, 60);
        this.fTextArea.setLineWrap(true);
        this.fTextArea.setWrapStyleWord(true);
        this.fTextArea.setEditable(false);
        JScrollPane textAreaPane = new JScrollPane(this.fTextArea, 20, 31);
        Dimension d = this.fUnusedDisplay.getPreferredSize();
        textAreaPane.setPreferredSize(new Dimension(d.width, d.height / 2));
        textAreaPane.setMinimumSize(textAreaPane.getPreferredSize());
        textAreaPane.setMaximumSize(textAreaPane.getPreferredSize());
        return textAreaPane;
    }

    protected void copyElements(LogoDisplay dest, LogoDisplay src) {
        StaticModel destModel;
        if (dest == null || src == null) {
            return;
        }
        StaticModel srcModel = (StaticModel)src.getModel();
        List cells = src.getSelectedCells();
        if (cells.size() == 0) {
            if (srcModel.getElementAt(src.getFocusPosition()) != null) {
                cells.add(src.getFocusPosition());
            } else {
                return;
            }
        }
        if ((destModel = (StaticModel)dest.getModel()).moveCellsFrom(srcModel, cells, dest.getFocusPosition())) {
            src.clearSelection();
            dest.clearSelection();
            src.repaint();
            dest.repaint();
        }
    }

    public void setLabels() {
        this.fMessageLabel.setText(Language.getString("dialog.parameter.message.EditManually.MessageTextArea", "Message Text Area"));
        this.fUnusedLabel.setText(Language.getString("dialog.parameter.message.EditManually.RecycleBin", "Recycle Bin"));
        this.fTextLabel.setText(Language.getString("dialog.parameter.message.EditManually.InfoWindow", "Info Window"));
        this.fTextArea.setText(Language.getString("dialog.parameter.message.EditManually.Desription1", "The static editor allows you to move, add, or delete message text elements without changing the position of any other elements.") + " " + Language.getString("dialog.parameter.message.EditManually.Desription2", "Drag and drop to and from the recycle bin to simplify moving and repositioning elements."));
    }

    public Dimension getPreferredSize() {
        Dimension ret = new Dimension(500, 256);
        if (this.fMessageDisplay != null) {
            Dimension base = this.fMessageDisplay.getPreferredSize();
            ret.setSize(base.width + 50, base.height * 3 + 50);
        }
        return ret;
    }

    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    public boolean checkFieldContents() {
        if (!this.isEmptyRecycleBin()) {
            return new LogoError(null, "dialog.parameter.message.EditManually.RecycleBinNotEmpty", "Delete contents in Recycle Bin?", 2, 1).display() == 0;
        }
        return true;
    }

    private boolean isEmptyRecycleBin() {
        Dimension d = this.fUnusedModel.getDisplayDimension();
        for (int x = 0; x < d.width; ++x) {
            for (int y = 0; y < d.height; ++y) {
                if (this.fUnusedModel.isEmptyCell(new Point(x, y))) continue;
                return false;
            }
        }
        return true;
    }

    public void loadFieldContents() throws ProgramException {
        if (this.fClipboardContent != null) {
            this.fUnusedModel.paste(this.fClipboardContent, new Point(0, 0));
        } else {
            if (this.fEditedCell != null) {
                this.fMessageModel.getDisplayElements()[this.fEditedCell.x][this.fEditedCell.y] = null;
            }
            if (this.fInsertedElement != null) {
                this.fUnusedModel.getDisplayElements()[0][0] = this.fInsertedElement;
            }
        }
    }

    public void storeFieldContents() {
        this.fMessageParameterDisplayModelRTF.setDisplayElemets(this.fMessageModel.getDisplayElementsClone());
    }

    public static class StaticModel
    extends MessageParameterDisplayModelRTF
    implements ExtenalMoveModel {
        private String errText = null;
        private JTextArea fTextArea = null;

        public StaticModel(MessageParameterDisplayModelRTF model) {
            super(model.getMessageParameter(), model.getCharSetID(), 0);
            super.setInsertMode(false);
            this.fDisplayElements = model.getDisplayElementsClone();
        }

        public void setInsertMode(boolean insertMode) {
            throw new UnsupportedOperationException();
        }

        protected boolean checkOverwriteArea(Point destination, DisplayElementInsertHandler.AreaInfo areaInfo) {
            return this.isWriteableArea(destination, areaInfo);
        }

        protected boolean checkOverwriteArea(Rectangle dimension) {
            return this.isWriteableArea(dimension);
        }

        private boolean isWriteableArea(Point destination, DisplayElementInsertHandler.AreaInfo areaInfo) {
            Rectangle screen = new Rectangle(this.fDisplayDimension);
            for (int y = 0; y < areaInfo.height; ++y) {
                Rectangle lineRectangle = new Rectangle(destination.x, destination.y + y, areaInfo.lengths[y], 1);
                if (!lineRectangle.isEmpty() && !screen.contains(lineRectangle)) {
                    return false;
                }
                for (int x = 0; x < areaInfo.lengths[y]; ++x) {
                    if (this.isEmptyCell(new Point(destination.x + x, destination.y + y))) continue;
                    return false;
                }
            }
            return true;
        }

        private boolean isWriteableArea(Rectangle dimension) {
            int x = dimension.x;
            while ((double)x < (double)dimension.x + dimension.getWidth()) {
                int y = dimension.y;
                while ((double)y < (double)dimension.y + dimension.getHeight()) {
                    if (!this.isEmptyCell(new Point(x, y))) {
                        return false;
                    }
                    ++y;
                }
                ++x;
            }
            return true;
        }

        public String getErrText() {
            return this.errText;
        }

        private void setErrText(String newText) {
            this.errText = newText;
            if (this.fTextArea != null) {
                if (this.fTextArea.getText().length() > 60) {
                    this.fTextArea.setText(this.errText);
                } else if (this.errText == null) {
                    this.fTextArea.setText(null);
                } else {
                    this.fTextArea.setText(this.fTextArea.getText() + "\n" + this.errText);
                }
            }
        }

        public void setTextListener(JTextArea listener) {
            this.fTextArea = listener;
        }

        public void clearAll() {
            for (int i = 0; i < this.fDisplayDimension.width; ++i) {
                for (int j = 0; j < this.fDisplayDimension.height; ++j) {
                    this.fDisplayElements[i][j] = null;
                }
            }
        }

        public boolean moveCells(List cells, Point destination) {
            if (!super.moveCells(cells, destination)) {
                this.setErrText(Language.getString("dialog.parameter.message.EditManually.errorCanNotMoveTo", "Can not move the area to here."));
            }
            return true;
        }

        public boolean moveCellsFrom(ExtenalMoveModel srcModel, List cells, Point destination) {
            if (srcModel == this) {
                return false;
            }
            List elements = srcModel.getCellsElements(cells);
            if (this.checkOverwriteArea(destination, new DisplayElementInsertHandler.AreaInfo(cells, elements))) {
                this.overwriteElements(destination, cells, elements);
                this.removeCells(srcModel, cells);
                this.setErrText(null);
            } else {
                this.setErrText(Language.getString("dialog.parameter.message.EditManually.errorCanNotMoveTo", "Can not move the area to here."));
            }
            return true;
        }

        private void removeCells(ExtenalMoveModel srcModel, List cells) {
            for (int i = 0; i < cells.size(); ++i) {
                Point cell = (Point)cells.get(i);
                Rectangle rect = srcModel.getElementBounds(cell);
                for (int x = rect.x; x < rect.x + rect.width; ++x) {
                    for (int y = rect.y; y < rect.y + rect.height; ++y) {
                        srcModel.getDisplayElements()[x][y] = null;
                    }
                }
            }
        }

        public boolean paste(Transferable clipboardContents, Point destination) {
            if (!super.paste(clipboardContents, destination)) {
                this.setErrText(Language.getString("dialog.logdisplay.elementOutOfBound", "Position conflict with another message text element."));
            }
            return true;
        }

        public boolean replaceBarElement(Point focus, Point destination, DisplayElement newElement) {
            if (!super.replaceBarElement(focus, destination, newElement)) {
                this.setErrText(Language.getString("dialog.logdisplay.elementOutOfBound", "Position conflict with another message text element."));
            }
            return true;
        }

        public boolean setElementAt(DisplayElement element, Point location) {
            if (!super.setElementAt(element, location)) {
                this.setErrText(Language.getString("dialog.logdisplay.elementOutOfBound", "Position conflict with another message text element."));
            }
            return true;
        }
    }
}

